VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form frmMonitor 
   Caption         =   "Suivi des commandes"
   ClientHeight    =   2415
   ClientLeft      =   195
   ClientTop       =   660
   ClientWidth     =   7935
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   ScaleHeight     =   2415
   ScaleWidth      =   7935
   Begin MSFlexGridLib.MSFlexGrid grdOrders 
      Height          =   2175
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   7695
      _ExtentX        =   13573
      _ExtentY        =   3836
      _Version        =   393216
      Cols            =   6
      FixedCols       =   0
      GridLines       =   0
      SelectionMode   =   1
      AllowUserResizing=   1
   End
End
Attribute VB_Name = "frmMonitor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' $Rvision: 2 $
' $Auteur: Davids $
' $Date: 4/16/98 12:25p $

'------------------------------------------------------------------------
' But:      Surveiller la file de rponse et la file d'acquittement.
'           MAJ des commandes et de leur statut dans la grille.
' Classes employes: Wrox Car Order Monitoring
' Rfrences:   Microsoft ActiveX Data Objects
'               MSFlexGrid
'------------------------------------------------------------------------

' on nomme les colonnes de la grille
Private Enum GridColumn
    mconColOrderNumber = 0
    mconColDateSent = 1
    mconColAck = 2
    mconColHOOrder = 3
    mconColDelivery = 4
End Enum

' composant de surveillance des commandes
Private WithEvents objMonitor       As wccOrderMonitorQ.OrderMonitorQ
Attribute objMonitor.VB_VarHelpID = -1

Private Sub Form_Load()
'
' But:          initialisation de la feuille
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998

    ' initialisation de la grille et affichage des commandes
    GridInitialise
    GridResize
    ShowOrders

    ' initialisation du composant de surveillance
    Set objMonitor = New wccOrderMonitorQ.OrderMonitorQ

End Sub

Private Sub Form_Resize()
'
' But:          Ajuster la grille  la taille de la feuille
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998

    GridResize

End Sub

Private Sub Form_Unload(Cancel As Integer)

    Set objMonitor = Nothing
    
End Sub

Private Sub objMonitor_OrderAck(OrderNumber As Long, Class As Long)
'
' But:      MAJ de la grille lorsqu'un acquittement est reu
' Arguments:    OrderNumber     numro de la commande chez le fabricant
'               Class           classe de message de l'acquittement
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998
' Note:         l'vnement est dclench par le composant de surveillance
'               lorsqu'un message arrive dans la file OrderAcknowledgment.

    ' MAJ de la colonne "Acquittement"
    SetGridCell OrderNumber, mconColAck, "Acknowledged"

End Sub

Private Sub objMonitor_OrderResponse(OrderNumber As Long, DeliveryDate As String, HOOrderNumber As String)
'
' But:      MAJ de la grille avec les donnes du message de rponse
' Arguments:    OrderNumber     numro de la commande dans la base de donne du concessionnaire
'               DeliveryDate    date de livraison du vhicule (la valeur est "Out of stock" si le modle n'est pas disponible)
'               HOOrderNumber   rfrence fabricant pour cette commande
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998
' Note:         l'vnement est dclench par le composant de surveillance lorsqu'un
'               message arrive dans la file OrderResponse.


    ' MAJ des colonnes "Date de livraison" et "Rfrence fabricant"
    SetGridCell OrderNumber, mconColDelivery, Format$(DeliveryDate, "Short Date")
    SetGridCell OrderNumber, mconColHOOrder, HOOrderNumber

End Sub

Public Sub OrderSent(OrderNumber As Long)
'
' But:          MAJ de la grille avec les donnes d'une nouvelle commande
' Arguments:    OrderNumber     numro de la commande chez le concessionnaire
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998
' Note:         les nouvelles commandes ne sont pas gres par le composant de surveillance
'               car on ne peut pas garantir que les nouveaux messages de la file NewOrder ne soient pas
'               extraits par le fabricant avant que le composant de surveillance puisse dtecter leur arrive.
'               Ici nous pouvons y remdier facilement : il suffit de mettre  jour la grille au moment
'               o l'on passe commande.

    ' on ajoute une nouvelle commande  la grille
    grdOrders.AddItem OrderNumber
    SetGridCell OrderNumber, mconColDateSent, Format$(Date, "Short Date")

End Sub

Private Sub GridResize()
'
' But:      ajuster la grille  la taille de la feuille, en conservant les mmes proportions pour les colonnes
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998

    Dim intCol              As Integer      ' colonne courante
    Dim intRatio            As Integer      ' largeur de la grille
    Dim adblRatio(5)        As Double       ' proportions des colonnes

    With grdOrders
        ' enregistrement des proportions
        For intCol = 0 To .Cols - 1
            adblRatio(intCol) = .ColWidth(intCol) / .Width
        Next

        ' on fixe la largeur et la hauteur  la taille de la feuille
        .Top = 0
        .Left = 0
        .Width = Me.Width
        .Height = Me.Height
        
        ' on dfinit la largeur des colonnes en tenant compte des proportions pralablement fixes
        For intCol = 0 To .Cols - 1
            .ColWidth(intCol) = .Width * adblRatio(intCol)
        Next
    End With

End Sub

Private Sub ShowOrders()
'
' But:      Afficher les commandes en attente de confirmation.
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998
' Note:         Cette mthode aurait pu faire l'objet d'un objet mtier.
'               Mais l'application est dj suffisament complique et
'               nous avons par ailleurs suffisament illustr le fonctionnement des objets mtier.

    Dim recR        As New ADODB.Recordset      ' Recordset pour les commandes non confirmes
    Dim lngOrderID  As Long                     ' ID de la commande chez le concessionnaire
    Dim strAck      As String                   ' chane d'acquittement

    ' obtention de les liste des commandes en attentes
    recR.Open "usp_OrdersNotConfirmed", RegistryRestore("Showroom", "Not Set"), adOpenForwardOnly, adLockReadOnly, adCmdStoredProc

    ' on parcourt les commandes avec une boucle
    While Not recR.EOF
        lngOrderID = recR("OrderID")

        ' on vrifie pour chaque commande qu'elle a t acquitte
        If IsNull(recR("Acknowledged")) Then
            strAck = ""
        Else
            strAck = "Acknowledged"
        End If

        ' et on ajoute les donnes dans la grille
        grdOrders.AddItem lngOrderID
        SetGridCell lngOrderID, mconColDateSent, Format$(recR("OrderDate"), "Short Date")
        recR.MoveNext
    Wend

    recR.Close
    Set recR = Nothing

End Sub

Private Function GetGridRow(lngOrderID As Long) As Long
'
' But:          retrouver la ligne de la grille correspondant  un numro de commande
' Arguments:    intOrderID      numro de la commande recherche
' Retours:      la ligne de la grille correspondant  la commande
' Auteur:       David Sussman
' Date:         17 Mar 1998

    Dim intIdx      As Long

    For intIdx = 1 To grdOrders.Rows - 1
        If GridCellContents(intIdx, mconColOrderNumber) = lngOrderID Then
            GetGridRow = intIdx
            Exit Function
        End If
    Next

End Function

Private Function GridCellContents(ByVal lngRow As Integer, ByVal lngColumn As GridColumn) As Variant
'
' But:      Retourner le contenu d'une cellule
' Arguments:    lngRow      ligne de la cellule
'               lngColumn   colonne de la cellule
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998

    With grdOrders
        GridCellContents = .TextArray(lngRow * .Cols + lngColumn)
    End With

End Function

Private Sub SetGridCell(ByVal OrderNumber As Long, ByVal Column As GridColumn, ByVal Value As Variant)
'
' But:      MAJ d'une cellule
' Arguments:    OrderNumber     numro de commande correspondant  la cellule que l'on veut metre  jour
'               Column          colonne dans laquelle se trouve la cellule
'               Value           valeur  placer dans la cellule
' Retours:      aucun
' Author:       David Sussman
' Date:         17 Mar 1998

    Dim intIdx      As Integer

    intIdx = GetGridRow(OrderNumber)

    grdOrders.TextArray(intIdx * grdOrders.Cols + Column) = Value

End Sub

Private Sub GridInitialise()
'
' But:          initialiser la grille
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998

    Dim intCol      As Integer      ' colonne

    With grdOrders
        ' on dfinit la valeur des cellules de la premire ligne (noms de colonne)
        .Clear
        .Rows = 1
        .Cols = 5
        .FormatString = "<N de la commande|^Date d'envoi|^Acquittement|<Rfrence fabricant|^Date de livraison"
        .Top = 0
        .Left = 0
        .Width = Me.Width
        .Height = Me.Height

        ' on dfinit la largeur initiale des colonnes (mme largeur pour toutes les colonnes)
        For intCol = 0 To .Cols - 1
            .ColWidth(intCol) = .Width / .Cols
        Next
    End With

End Sub
